# Resources

This guide will show you how to set a Content-Disposition when working with resources.

## How to change Content-Disposition

Refinery comes with support for uploading files (in addition to images). By default, file uploads are given an http header of `Content-Disposition: attachment; filename=xxx`

This option forces the users' browser to download (or save as) the file. This is a good option for many file types, but if you want to be able to upload PDFs and you want your users to be able to preview the PDF in the browser (as is normally the standard), you may want to customize that content disposition configuration.

You can do this by making use of the `after_inclusion` hook refinery provides:

```ruby
# config/application.rb
# refinery change content-disipotion
Refinery::Core::Engine.after_inclusion do
  Refinery::Resource # force autoload

  ::Dragonfly.app(:refinery_resources).response_header('Content-Disposition', nil)
end
```

You want this code to be placed inside the `class Application < Rails::Application` class. Once you restart your web server, you'll now be able to preview PDFs in the browser as long as your browser supports it. If it's a file type the browser does not recognize, it'll prompt the user to download anyway.